# Sound — Detection Predicate (Pinned)

**Goal.** Detect a tone burst in noise and obtain the threshold amplitude \( A_{\text{th}}(\Theta) \) that **scales** as \( A_{\text{th}} \propto \Theta^{-1/2} \).

## Stimulus & Template

- For \( \Theta \in \{16,32,64\} \), synthesize a **sinusoidal burst** of **length Θ** samples, **per‑sample amplitude A** (no RMS normalization), **frequency** \( f_0 = 1/16 \) cycles/sample (⇒ 1,2,4 cycles in the window).  
- Matched filter uses the *same* \( f_0 \); compute raw sums (no division by Θ):
  \[
  C(t)=\sum_{i=0}^{\Theta-1} x[t+i]\cos(2\pi f_0 i),\quad
  S(t)=\sum_{i=0}^{\Theta-1} x[t+i]\sin(2\pi f_0 i)
  \]
- Global noise scale \( \sigma_{\text{global}} \) estimated once from a long pre‑stimulus region.

**Statistic** (two‑quadrature magnitude):
\[
T_\Theta(t) = \frac{\sqrt{C(t)^2+S(t)^2}}{\sigma_{\text{global}}\sqrt{\Theta}}.
\]

## Probe & Localization

- **Probe window** \( \mathcal W_\Theta = [t_0-\Theta,\,t_0+\Theta-1] \) (length \(2\Theta\)).  
- **Localization gate:** accept only if \( \hat t = \arg\max_{t\in\mathcal W_\Theta} T_\Theta(t) \) satisfies \(|\hat t - t_0| \le \Theta/4\).

## False‑Alarm Control (fixed \(p_{\mathrm{FA}}\))

- Choose a per‑trial false‑alarm rate \( p_{\mathrm{FA}} = 0.01 \).  
- Set threshold \( \tau_\Theta \) so that
  \[
  \Pr\!\big[\max_{t\in\mathcal W_\Theta} T_\Theta(t) \ge \tau_\Theta \mid \text{noise only}\big] = p_{\mathrm{FA}}.
  \]
- Method:
  - **Analytic (Rayleigh EV):** \( \tau_\Theta = \sqrt{-2\ln(1-(1-p_{\mathrm{FA}})^{1/N_\Theta})} \), with \(N_\Theta=|\mathcal W_\Theta|\).
  - **Bootstrap (recommended):** draw many noise‑only probes; set \( \tau_\Theta \) to the empirical \( (1-p_{\mathrm{FA}}) \) quantile of \( \max T_\Theta \).

## Threshold search

- For each Θ: bracket‑and‑bisect amplitude \( A \in [10^{-4},\,0.6] \) to 5% width.  
- **Detect** iff \( \max_{t\in\mathcal W_\Theta} T_\Theta(t) \ge \tau_\Theta \) **and** localization holds.

## Preflight

- **Coherence:** with noise=0, verify \( T_\Theta^{\max} \) ratios ≈ \( \sqrt{2} \) when Θ doubles (±5%).  
- **Noise‑only:** with \( A=0 \), empirical detect rate ≈ \( p_{\mathrm{FA}} \) (±0.5%).

## Acceptance

- Slope \( m \) of \( \log A_{\text{th}} \) vs \( \log \Theta \) satisfies \( m \in [-0.6,-0.4] \).  
- \( A_{\text{th}}(\Theta) \) strictly non‑increasing with Θ.  
- Re‑centering: ±1 sample shift unchanged within 5% bisection tolerance.

## Manifest fields

```jsonc
{
  "sound": {
    "detect_test": "probe_max_mf_sine_mag_over_sigma_sqrtTheta",
    "f0_cycles_per_sample": 0.0625,
    "false_alarm": { "method": "bootstrap", "pFA": 0.01,
                     "tau": { "16": 6.22, "32": 6.78, "64": 6.34 } },
    "global_sigma": 1.00,
    "A_th": { "16": 0.0XX, "32": 0.0YY, "64": 0.0ZZ },
    "loglog_slope": -0.51,
    "recenter_ok": true,
    "preflight": {
      "sqrtTheta_scaling_ok": true,
      "noise_only_detect_rate": 0.010
    }
  }
}
```
